/********************************************************************
 FileName:     	Demo Board Hardware
	by Mauro Grassi September 2009

********************************************************************/
#include "p18f27j53.h"


#ifndef HARDWARE_PROFILE_DEMO_BOARD_H
#define HARDWARE_PROFILE_DEMO_BOARD_H

	
    /*******************************************************************/
    /******** USB stack hardware selection options *********************/
    /*******************************************************************/
    //This section is the set of definitions required by the MCHPFSUSB
    //  framework.  These definitions tell the firmware what mode it is
    //  running in, and where it can find the results to some information
    //  that the stack needs.
    //These definitions are required by every application developed with
    //  this revision of the MCHPFSUSB framework.  Please review each
    //  option carefully and determine which options are desired/required
    //  for your application.

    //#define USE_SELF_POWER_SENSE_IO
    //#define tris_self_power     TRISAbits.TRISA0    // Input
    #define self_power          1

    //#define USE_USB_BUS_SENSE_IO
    //#define tris_usb_bus_sense  TRISAbits.TRISA1    // Input
    #define USB_BUS_SENSE       1 
 
    //Uncomment this to make the output HEX of this project 
    //   to be able to be bootloaded using the HID bootloader
	//#define PROGRAMMABLE_WITH_USB_HID_BOOTLOADER		

    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/
    /******** Application specific definitions *************************/
    /*******************************************************************/
    /*******************************************************************/
    /*******************************************************************/

    /** Board definition ***********************************************/
    //These defintions will tell the main() function which board is
    //  currently selected.  This will allow the application to add
    //  the correct configuration bits as wells use the correct
    //  initialization functions for the board.  These defitions are only
    //  required in the stack provided demos.  They are not required in
    //  final application design.
	//  #define DEMO_BOARD PIC18F46J50_PIM
    //	#define PIC18F46J50_PIM

    #define CLOCK_FREQ 				48000000
    #define GetSystemClock() 		CLOCK_FREQ   
    #define GetInstructionClock() 	(GetSystemClock()/4)
	    
    /** I/O pin definitions ********************************************/
    #define INPUT_PIN 	1
    #define OUTPUT_PIN 	0

#endif  

